#pragma once
#include "GameItems.h"
#include "Animation.h"
#include "Mushroom.h"
#include "OneUp.h"

class Block : public GameItems
{
public:
	
	Block();
	~Block();

	void create(BlockType type, StoredItems item);	//Creates a block of BlockType type, and has a StoredItem item

	void update(float dt);
	void handleCollision(MySprite* sprite, float dt);

	bool getItemReleasing();	//Get whether or not the block is currently animating releasing a Power Up or One Up

private:
	sf::Texture mushroomTexture;	//		Release Item Textures
	sf::Texture oneUpTexture;		//

	BlockType blockType;	//The type of block (floor, destructable, question...) - will affect drawn texture and block behaviour
	StoredItems storedItem;	//The item stored within the block

	Animation questionAnim;		//
	Animation releaseMushroom;	//		Block Animations
	Animation releaseOneUp;	//

	bool isItemReleasing;	//Whether or not the block is currently animating releasing a Power Up or One Up

	void releaseStoredItem(Mario* mario);	//releaseStoredItem is called when Mario head collides with the block and begins to release the storedItem if there is one
};

